/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import morph.avaritia.util.ToolHelper;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;

public class AEOCrawlerTaskHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static Map<ResourceKey<Level>, List<Crawler>> crawlerTasks = new HashMap<ResourceKey<Level>, List<Crawler>>();

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(AEOCrawlerTaskHandler::onTickEnd);
        MinecraftForge.EVENT_BUS.addListener(AEOCrawlerTaskHandler::worldUnload);
    }

    public static void onTickEnd(TickEvent.WorldTickEvent event) {
        ResourceKey dim;
        if (event.phase == TickEvent.Phase.END && !event.world.f_46443_ && crawlerTasks.containsKey(dim = event.world.m_46472_())) {
            List<Crawler> crawlers = crawlerTasks.get(dim);
            List<Crawler> slice = crawlers.subList(crawlers.size() - Math.min(crawlers.size(), 40), crawlers.size());
            LinkedList<Crawler> copy = new LinkedList<Crawler>(slice);
            slice.clear();
            for (Crawler crawler : copy) {
                crawler.tick();
            }
        }
    }

    public static void worldUnload(WorldEvent.Unload event) {
        LevelAccessor accessor = event.getWorld();
        if (accessor instanceof Level) {
            Level level = (Level)accessor;
            crawlerTasks.remove(level.m_46472_());
        }
    }

    public static void startCrawlerTask(Level world, Player player, ItemStack stack, BlockPos coords, int steps, int leafStep, boolean leaves, boolean force, Set<BlockPos> posChecked) {
        if (world.f_46443_) {
            return;
        }
        Crawler crawler = new Crawler(world, player, stack, coords, steps, leafStep, leaves, force, posChecked);
        ResourceKey dim = world.m_46472_();
        crawlerTasks.computeIfAbsent((ResourceKey<Level>)dim, e -> new ArrayList()).add(crawler);
    }

    public static class Crawler {
        final Level level;
        final Player player;
        final ItemStack stack;
        final int steps;
        final BlockPos origin;
        private int leafStep;
        final boolean leaves;
        final boolean force;
        final Set<BlockPos> posChecked;

        private Crawler(Level level, Player player, ItemStack stack, BlockPos origin, int steps, int leafStep, boolean leaves, boolean force, Set<BlockPos> posChecked) {
            this.level = level;
            this.player = player;
            this.stack = stack;
            this.origin = origin;
            this.steps = steps;
            this.leafStep = leafStep;
            this.leaves = leaves;
            this.force = force;
            this.posChecked = posChecked;
        }

        protected void tick() {
            if (!this.force && this.level.m_46859_(this.origin)) {
                return;
            }
            ToolHelper.removeBlockWithDrops(this.player, this.stack, this.level, this.origin, null, 0.0f);
            if (this.steps == 0 || this.leafStep > 5) {
                return;
            }
            if (this.leafStep != 0) {
                // empty if block
            }
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.origin.m_142082_(-1, -1, -1), (BlockPos)this.origin.m_142082_(1, 1, 1))) {
                if (pos.equals((Object)this.origin)) continue;
                this.searchBlock(pos.m_7949_());
            }
        }

        private void searchBlock(BlockPos stepPos) {
            if (!this.posChecked.add(stepPos)) {
                return;
            }
            BlockState stepState = this.level.m_8055_(stepPos);
            boolean log = stepState.m_204336_(BlockTags.f_13106_);
            boolean leaf = stepState.m_204336_(BlockTags.f_13035_);
            if (log || leaf) {
                int steps = this.steps - 1;
                this.leafStep = leaf ? ++this.leafStep : 0;
                AEOCrawlerTaskHandler.startCrawlerTask(this.level, this.player, this.stack, stepPos, steps, this.leafStep, leaf, false, this.posChecked);
            }
        }
    }
}

